#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

void swap(vector<long long> &v, int x, int y);

void quicksort(vector<long long> &vec, int L, int R)
{
    int i, j, mid, piv;
    i = L;
    j = R;
    mid = L + (R - L) / 2;
    piv = vec[mid];

    while (i < R || j > L)
    {
        while (vec[i] < piv)
            i++;
        while (vec[j] > piv)
            j--;

        if (i <= j)
        {
            swap(vec, i, j);
            i++;
            j--;
        }
        else
        {
            if (i < R)
                quicksort(vec, i, R);
            if (j > L)
                quicksort(vec, L, j);
            return;
        }
    }
}

void swap(vector<long long> &v, int x, int y)
{
    long long temp = v[x];
    v[x] = v[y];
    v[y] = temp;
}

int main()
{
    int N, M, K, L;
    scanf("%d%d%d%d", &N, &M, &K, &L);
    long long x;
    if (K == 1 && L == 1)
    {
        long long zbir = 0;
        for (int i = 0; i < N * M; i++)
        {
            scanf("%lld", &x);
            zbir += x;
        }
        cout << zbir;
    }
    else
    {
        vector<long long> br(N * M);
        for (int i = 0; i < N * M; i++)
        {
            scanf("%lld", &br[i]);
        }
        quicksort(br, 0, N * M - 1);
        long long zbir = br[N * M - 1] * 4 + (br[N * M - 2] + br[N * M - 3] + br[N * M - 4] + br[N * M - 5]) * 2;
        for (int i = 0; i < N * M - 5; i++)
        {
            zbir += br[i];
        }
        cout << zbir;
    }
    return 0;
}